% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position.R
\name{position}
\alias{position}
\alias{position.data.frame}
\alias{position.matrix}
\alias{position.numeric}
\alias{position.integer}
\alias{position64}
\alias{position64.data.frame}
\alias{position64.matrix}
\alias{position64.double}
\alias{position64.integer}
\alias{position64.numeric}
\alias{position64.integer64}
\alias{position64.character}
\alias{position64.bitstring}
\title{Get index positions from a Hilbert Curve}
\usage{
position(h, ..., n = 10L)

\method{position}{data.frame}(h, ..., n, idx = 1, attach = TRUE)

\method{position}{matrix}(h, ..., n, idx = 1, attach = TRUE)

\method{position}{numeric}(h, ..., n)

\method{position}{integer}(h, ..., n)

position64(h, ..., n = 10L)

\method{position64}{data.frame}(h, ..., n, idx = 1, attach = TRUE)

\method{position64}{matrix}(h, ..., n, idx = 1, attach = TRUE)

\method{position64}{double}(h, ..., n)

\method{position64}{integer}(h, ..., n)

\method{position64}{numeric}(h, ..., n)

\method{position64}{integer64}(h, ..., n)

\method{position64}{character}(h, ..., n)

\method{position64}{bitstring}(h, ..., n)
}
\arguments{
\item{h}{One of: Integer vector, \code{data.frame}, or \code{matrix}.}

\item{...}{Unused.}

\item{n}{Exponent to the dimensions of the underlying grid. The Hilbert
Curve indices are based on a \verb{2^n x 2^n} grid. This number
must be less than 15 due to the 32-bit implementation of R. This \emph{must}
be the same as the \code{n} used in \code{index}.}

\item{idx}{Column name or index containing the Hilbert Curve indices.}

\item{attach}{If \code{TRUE}, adds the position as new columns to the given
\code{data.frame}/\code{matrix}. If \code{h} is a \code{data.frame}, then the
columns are named \code{x} and \code{y}; otherwise, it is two unnamed columns at
the end of the matrix.}
}
\value{
A \code{data.frame} containing the positions as \code{integer}
columns \code{x} and \code{y}, or the original object
(\code{data.frame} or \code{matrix}) with the columns attached.
When \code{n} is greater than 15, the positions are of
type \code{bit64::integer64}.
}
\description{
Get index positions from a Hilbert Curve
}
