% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highcharts-api.R
\name{hc_loading}
\alias{hc_loading}
\title{Loading options for highcharter objects}
\usage{
hc_loading(hc, ...)
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{...}{Arguments defined in \url{https://api.highcharts.com/highcharts/loading}.}
}
\description{
The loading options control the appearance of the loading screen
that covers the plot area on chart operations. This screen only
appears after an explicit call to chart.showLoading(). It is a
utility for developers to communicate to the end user that something
is going on, for example while retrieving new data via an XHR connection.
The "Loading..." text itself is not part of this configuration
object, but part of the lang object.
}
\examples{

highcharts_demo() \%>\%
  hc_loading(
    hideDuration = 1000,
    showDuration = 1000
  )
}
