% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_globe.R
\name{plot_globe}
\alias{plot_globe}
\title{Plot hexagonized globe}
\usage{
plot_globe(
  area = 50000,
  center = "europe",
  clip_to_land = FALSE,
  land_data = NULL,
  exclude_antarctica = TRUE,
  fill = "#D4B896",
  border = "grey30",
  border_width = 0.2,
  ocean_fill = "white",
  ocean_border = "grey50",
  show_land = clip_to_land,
  land_fill = NA,
  land_border = "grey40",
  land_width = 0.3,
  use_ggplot = NULL,
  return_data = FALSE,
  aperture = 3L
)
}
\arguments{
\item{area}{Cell area in km^2 (passed to \code{\link{hex_grid}})}

\item{center}{Globe center: either a preset name (e.g., "europe") or
numeric vector c(lon, lat). See \code{\link{globe_centers}} for presets.}

\item{clip_to_land}{If TRUE, clip hexagons to land boundaries}

\item{land_data}{Optional sf object for land boundaries. If NULL and
clip_to_land is TRUE, uses rnaturalearth::ne_countries()}

\item{exclude_antarctica}{If TRUE, exclude Antarctica from land clipping}

\item{fill}{Fill color for hexagons (default "#D4B896")}

\item{border}{Border color for hexagons (default "grey30")}

\item{border_width}{Border width for hexagons (default 0.2)}

\item{ocean_fill}{Fill color for ocean/globe background (default "white")}

\item{ocean_border}{Border color for globe circle (default "grey50")}

\item{show_land}{If TRUE, show land boundaries (default TRUE when clipping)}

\item{land_fill}{Fill color for land (default NA, transparent)}

\item{land_border}{Border color for land boundaries (default "grey40")}

\item{land_width}{Border width for land boundaries (default 0.3)}

\item{use_ggplot}{NULL = auto-detect, TRUE = force ggplot2, FALSE = force base}

\item{return_data}{If TRUE, return sf objects instead of plotting}

\item{aperture}{Grid aperture (default 3L)}
}
\value{
If use_ggplot = TRUE: ggplot2 object (can add layers with +)
If use_ggplot = FALSE: NULL invisibly (plots directly)
If return_data = TRUE: list of sf objects (hexagons, land, ocean_circle, crs)
}
\description{
Renders a global hexagonal grid on an orthographic projection with
customizable rotation, land clipping, and styling options.
}
\details{
The function handles several technical challenges:
\itemize{
\item Hexagons on the back side of the globe fail to transform - these are
filtered out gracefully
\item Invalid geometries after projection are repaired with st_buffer(0)
\item Clipping is done in orthographic CRS to avoid topology errors
}
}
\examples{
\donttest{
# Get data for custom plotting (no rendering)
data <- plot_globe(area = 100000, center = "europe", return_data = TRUE)
nrow(data$hexagons)
class(data$ocean_circle)

# Basic usage - Europe-centered globe
plot_globe(area = 80000, center = "europe")
}
}
\seealso{
\code{\link{globe_centers}} for available presets,
\code{\link{grid_global}} for generating global grids without plotting
}
