% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosswalk.R
\name{h3_crosswalk}
\alias{h3_crosswalk}
\title{Crosswalk Between ISEA and H3 Cell IDs}
\usage{
h3_crosswalk(
  cell_id = NULL,
  grid,
  h3_resolution = NULL,
  isea_grid = NULL,
  direction = c("isea_to_h3", "h3_to_isea")
)
}
\arguments{
\item{cell_id}{Cell IDs to translate. Numeric for ISEA, character for H3.
When \code{grid} is a HexData object and \code{cell_id} is \code{NULL},
all cell IDs from the data are used.}

\item{grid}{A HexGridInfo or HexData object. For \code{direction =
"isea_to_h3"}, this must be an ISEA grid. For \code{direction =
"h3_to_isea"}, this must be an H3 grid.}

\item{h3_resolution}{Target H3 resolution for \code{"isea_to_h3"}, or the
source H3 resolution for \code{"h3_to_isea"}. When \code{NULL} (default),
the closest H3 resolution matching the ISEA cell area is selected
automatically.}

\item{isea_grid}{A HexGridInfo for the target ISEA grid. Required when
\code{direction = "h3_to_isea"}.}

\item{direction}{One of \code{"isea_to_h3"} (default) or \code{"h3_to_isea"}.}
}
\value{
A data frame with columns:
\describe{
\item{isea_cell_id}{ISEA cell ID (numeric)}
\item{h3_cell_id}{H3 cell ID (character)}
\item{isea_area_km2}{Area of the ISEA cell in km2}
\item{h3_area_km2}{Geodesic area of the H3 cell in km2}
\item{area_ratio}{Ratio of ISEA area to H3 area}
}
}
\description{
Maps cell IDs between ISEA (equal-area) and H3 grid systems by looking up
each cell's center coordinate in the target grid. This enables workflows
where analysis is done in ISEA (exact equal-area) and reporting in H3
(industry-standard).
}
\details{
The crosswalk works by computing the center coordinate of each source cell,
then finding which cell in the target grid contains that center. This is a
many-to-one mapping: multiple ISEA cells may map to the same H3 cell (or
vice versa) depending on the relative resolutions.

When \code{h3_resolution} is \code{NULL} and \code{direction = "isea_to_h3"},
the H3 resolution whose average cell area is closest to the ISEA cell area
is chosen automatically. This gives the best 1:1 correspondence.
}
\examples{
\donttest{
# ISEA -> H3
grid <- hex_grid(area_km2 = 1000)
cells <- lonlat_to_cell(c(0, 10, 20), c(45, 50, 55), grid)
xwalk <- h3_crosswalk(cells, grid)
head(xwalk)

# H3 -> ISEA
h3 <- hex_grid(resolution = 5, type = "h3")
h3_cells <- lonlat_to_cell(c(0, 10), c(45, 50), h3)
xwalk2 <- h3_crosswalk(h3_cells, h3, isea_grid = grid, direction = "h3_to_isea")
}
}
\seealso{
\code{\link{cell_area}} for per-cell area computation,
\code{\link{hex_grid}} for creating grids
}
