% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_index.R
\name{hexify_cell_id_to_quad_ij}
\alias{hexify_cell_id_to_quad_ij}
\title{Get cell info from cell ID}
\usage{
hexify_cell_id_to_quad_ij(cell_id, resolution, aperture)
}
\arguments{
\item{cell_id}{Numeric vector of cell IDs (1-based)}

\item{resolution}{Grid resolution (integer >= 0)}

\item{aperture}{Grid aperture (3, 4, or 7)}
}
\value{
Data frame with quad, i, j columns
}
\description{
Converts cell ID to cell components (quad, i, j).
}
\examples{
info <- hexify_cell_to_quad_ij(1702, resolution = 5, aperture = 3)
}
\seealso{
Other coordinate conversion: 
\code{\link{hexify_cell_to_icosa_tri}()},
\code{\link{hexify_cell_to_lonlat}()},
\code{\link{hexify_cell_to_plane}()},
\code{\link{hexify_cell_to_quad_ij}()},
\code{\link{hexify_cell_to_quad_xy}()},
\code{\link{hexify_grid_cell_to_lonlat}()},
\code{\link{hexify_grid_to_cell}()},
\code{\link{hexify_icosa_tri_to_plane}()},
\code{\link{hexify_icosa_tri_to_quad_ij}()},
\code{\link{hexify_icosa_tri_to_quad_xy}()},
\code{\link{hexify_lonlat_to_cell}()},
\code{\link{hexify_lonlat_to_plane}()},
\code{\link{hexify_lonlat_to_quad_ij}()},
\code{\link{hexify_quad_ij_to_cell}()},
\code{\link{hexify_quad_ij_to_icosa_tri}()},
\code{\link{hexify_quad_ij_to_xy}()},
\code{\link{hexify_quad_xy_to_cell}()},
\code{\link{hexify_quad_xy_to_icosa_tri}()},
\code{\link{hexify_roundtrip_test}()}
}
\concept{coordinate conversion}
\keyword{internal}
