% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_index.R
\name{hexify_index_to_cell}
\alias{hexify_index_to_cell}
\title{Convert index string to cell coordinates}
\usage{
hexify_index_to_cell(
  index,
  aperture = 3L,
  index_type = c("auto", "z3", "z7", "zorder")
)
}
\arguments{
\item{index}{Index string}

\item{aperture}{Aperture (3, 4, or 7)}

\item{index_type}{Index encoding used. Default "auto" infers from aperture.}
}
\value{
List with face, i, j, and resolution
}
\description{
Decodes a hierarchical index string back to cell coordinates.
}
\examples{
cell <- hexify_index_to_cell("0012012", aperture = 3)
}
\seealso{
Other hierarchical index: 
\code{\link{hexify_cell_to_index}()},
\code{\link{hexify_compare_indices}()},
\code{\link{hexify_default_index_type}()},
\code{\link{hexify_get_children}()},
\code{\link{hexify_get_parent}()},
\code{\link{hexify_get_resolution}()},
\code{\link{hexify_index_to_lonlat}()},
\code{\link{hexify_is_valid_index_type}()},
\code{\link{hexify_lonlat_to_index}()},
\code{\link{hexify_z7_canonical}()}
}
\concept{hierarchical index}
\keyword{internal}
