% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heuristics.R
\name{minModel}
\alias{minModel}
\title{Minimalist Model}
\usage{
minModel(
  train_data,
  criterion_col,
  cols_to_fit,
  reverse_cues = TRUE,
  fit_name = "minModel"
)
}
\arguments{
\item{train_data}{Training/fitting data as a matrix or data.frame.}

\item{criterion_col}{The index of the column in train_data that has the
criterion.}

\item{cols_to_fit}{A vector of column indices in train_data, used to fit
the criterion.}

\item{reverse_cues}{Optional parameter to reverse cues as needed.  By
default, the model will reverse the cue values for cues with cue validity
< 0.5, so a cue with validity 0 becomes a cue with validity 1.
Set this to FALSE if you do not want that, i.e. the cue stays validity 0.}

\item{fit_name}{Optional The name other functions can use to label output.
It defaults to the class name.}
}
\value{
An object of \code{\link[base]{class}} minModel, which can be
passed to a variety of functions to make predictions, e.g.
\code{\link{predictPair}} and \code{\link{percentCorrectList}}.
}
\description{
Fit the Minimalist heuristic by specifying columns and a dataset. It
searches cues in a random order, making a decision based on the first cue
that discriminates (has differing values on the two objects).
}
\examples{
## Fit column (5,4) to column (1,0), having validity 1.0, and column (0,1),
## validity 0.
train_matrix <- cbind(c(5,4), c(1,0), c(0,1))
min <- minModel(train_matrix, 1, c(2,3))
predictPair(oneRow(train_matrix, 1), oneRow(train_matrix, 2), min)

}
\seealso{
\code{\link{predictPairProb}} for prediction.


}
