% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.heumilkr_solution}
\alias{autoplot.heumilkr_solution}
\title{Create ggplot for a CVRP solution}
\usage{
\method{autoplot}{heumilkr_solution}(object, ...)
}
\arguments{
\item{object}{A "\code{heumilkr_solution}" object, typically obtained by \code{\link[=clarke_wright]{clarke_wright()}}.}

\item{...}{Not used.}
}
\value{
A ggplot object.
}
\description{
Represents the sites and runs on a 2D plane so that the distances between
sites on the drawn 2D plane correspond to \code{distances} provided to the
solver \code{clarke_wright()}.

The individual runs are distinguished by color.
The demanding site locations are marked with round circles while the
(single) supplying site is depicted as a square.
The line types (solid/dashed/...) are associated to different vehicle types.
}
\details{
Distance information between sites only determine
site positions on a 2D plane up to rotations and translations:
those are fixed arbitrarily.
}
