% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.hero_bspline.R
\name{predict.hero_bspline}
\alias{predict.hero_bspline}
\title{Predict method for \code{hero_bspline} object}
\usage{
\method{predict}{hero_bspline}(object, newx, nderiv = 0L, sparse = TRUE, ...)
}
\arguments{
\item{object}{A \code{hero_bspline} object created by
\code{\link{bspline}}}

\item{newx}{A numeric vector of values at which to
evaluate the B-spline functions or derivatives.}

\item{nderiv}{An integer value specifying the derivative order of the B-splines.  The default is 0.}

\item{sparse}{A logical value indicating if the result
should be a sparse version of the
\code{\link[Matrix]{Matrix-class}}.}

\item{...}{Not currently implemented.}
}
\value{
An \eqn{n \times k} matrix (or
  \code{\link[Matrix]{Matrix-class}} object if
  \code{sparse = TRUE}), where \eqn{n} is the number of
  values in \code{newx} and \eqn{k} is the number of
  basis functions in \code{object}.  Each row gives the
  predicted values of the basis functions for the
  appropriate value of \code{newx}.
}
\description{
Predicted values based on object created by
\code{\link{bspline}}.
}
\examples{
b = bspline(nbasis = 10)
p = predict(b, newx = seq(0, 1, len = 101))
}
\seealso{
\code{\link{bspline}}
}
