% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_general.R
\name{cor}
\alias{cor}
\title{A wrapper around the stats::cor function adding two additional methods, 
namely method = "hermite.spearman" and method = "hermite.kendall" (can be
abbreviated). The input parameters and output value semantics closely match 
the stats::cor method for easy interchange. If neither the 
"hermite.spearman" nor the "hermite.kendall" method is selected, then this 
function will call stats::cor with the arguments provided.}
\usage{
cor(x, y = NULL, use = "everything", method = "pearson", ...)
}
\arguments{
\item{x}{a numeric vector, matrix or data frame.}

\item{y}{NULL (default) or a vector, matrix or data frame with 
compatible dimensions to x. The default is equivalent to y = x 
(but more efficient).}

\item{use}{not used by hermite.spearman and hermite.kendall methods. For 
stats::cor this is an optional character string giving a method for 
computing covariances in the presence of missing values. 
This must be (an abbreviation of) one of the strings "everything", 
"all.obs", "complete.obs", "na.or.complete", or "pairwise.complete.obs".}

\item{method}{a character string indicating which correlation coefficient 
is to be computed. One of "pearson" (default), "kendall", "spearman", 
"hermite.spearman" or "hermite.kendall": can be abbreviated.}

\item{...}{Additional arguments for the constructor of the hermite_estimator
object if method is "hermite.spearman" or "hermite.kendall".}
}
\description{
A wrapper around the stats::cor function adding two additional methods, 
namely method = "hermite.spearman" and method = "hermite.kendall" (can be
abbreviated). The input parameters and output value semantics closely match 
the stats::cor method for easy interchange. If neither the 
"hermite.spearman" nor the "hermite.kendall" method is selected, then this 
function will call stats::cor with the arguments provided.
}
