% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heaping_indices.R
\name{jdanov}
\alias{jdanov}
\title{Jdanov's Old-Age Heaping Index}
\usage{
jdanov(x, Agei = c(95, 100, 105), weight = NULL)
}
\arguments{
\item{x}{numeric vector of individual ages.}

\item{Agei}{numeric vector of specific ages to evaluate (default
c(95, 100, 105)).}

\item{weight}{optional numeric vector of sampling weights.}
}
\value{
A single numeric value representing Jdanov's index.
}
\description{
Jdanov's index is designed to detect age heaping at very old ages
(typically 95+), where data quality is often poorest. It applies
the Whipple principle to specific old-age values.
}
\details{
Calculate Jdanov's index for detecting heaping at very old ages.


The index compares counts at specified old ages to the surrounding
5-year age groups, similar to the standard Whipple approach but
focused on the oldest ages where heaping is most problematic.

Interpretation:
\itemize{
  \item 100: no heaping
  \item >100: preference for the specified ages
  \item 500: maximum heaping (all ages at specified values)
}
}
\examples{
# Create old-age data with heaping
set.seed(42)
age <- c(sample(90:110, 2000, replace = TRUE),
         rep(c(95, 100, 105), each = 100))  # Add heaping
jdanov(age)  # Should be > 100

# No heaping
age_uniform <- sample(90:110, 2000, replace = TRUE)
jdanov(age_uniform)  # Should be close to 100

}
\references{
Jdanov, D. A., Scholz, R. D., and Shkolnikov, V. M. (2008).
Official population statistics and the Human Mortality Database
estimates of populations aged 80+ in Germany and nine other
European countries. \emph{Demographic Research}, \strong{19},
1169-1196.
}
\seealso{
\code{\link{kannisto}} for Kannisto's index,
  \code{\link{coale_li}} for Coale-Li index.

Other heaping indices: 
\code{\link{bachi}()},
\code{\link{coale_li}()},
\code{\link{heaping_indices}()},
\code{\link{kannisto}()},
\code{\link{myers}()},
\code{\link{noumbissi}()},
\code{\link{spoorenberg}()},
\code{\link{whipple}()}
}
\author{
Matthias Templ
}
\concept{heaping indices}
