% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-prep-c50.R
\name{hai_c50_data_prepper}
\alias{hai_c50_data_prepper}
\title{Prep Data for C5.0 - Recipe}
\usage{
hai_c50_data_prepper(.data, .recipe_formula)
}
\arguments{
\item{.data}{The data that you are passing to the function. Can be any type
of data that is accepted by the \code{data} parameter of the \code{recipes::recipe()}
function.}

\item{.recipe_formula}{The formula that is going to be passed. For example
if you are using the \code{iris} data then the formula would most likely be something
like \code{Species ~ .}}
}
\value{
A recipe object
}
\description{
Automatically prep a data.frame/tibble for use in the C5.0 algorithm.
}
\details{
This function will automatically prep your data.frame/tibble for
use in the C5.0 algorithm. The C5.0 algorithm is a lazy learning classification
algorithm. It expects data to be presented in a certain fashion.

This function will output a recipe specification.
}
\examples{
library(ggplot2)
library(tibble)

Titanic <- as_tibble(Titanic)

hai_c50_data_prepper(.data = Titanic, .recipe_formula = Survived ~ .)
rec_obj <- hai_c50_data_prepper(Titanic, Survived ~ .)
get_juiced_data(rec_obj)

}
\seealso{
\url{https://www.rulequest.com/see5-unix.html}

Other Preprocessor: 
\code{\link{hai_cubist_data_prepper}()},
\code{\link{hai_data_impute}()},
\code{\link{hai_data_poly}()},
\code{\link{hai_data_scale}()},
\code{\link{hai_data_transform}()},
\code{\link{hai_data_trig}()},
\code{\link{hai_earth_data_prepper}()},
\code{\link{hai_glmnet_data_prepper}()},
\code{\link{hai_knn_data_prepper}()},
\code{\link{hai_ranger_data_prepper}()},
\code{\link{hai_svm_poly_data_prepper}()},
\code{\link{hai_svm_rbf_data_prepper}()},
\code{\link{hai_xgboost_data_prepper}()}

Other C5.0: 
\code{\link{hai_auto_c50}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{C5.0}
\concept{Preprocessor}
