% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdf5-functions.R
\name{h5AbsLinkName}
\alias{h5AbsLinkName}
\title{Format an absolute path name for HDF5 link}
\usage{
h5AbsLinkName(name)
}
\arguments{
\item{name}{String representing an expected name of HDF5 link.}
}
\value{
An update \code{name} starting with '/'.
}
\description{
Format an absolute path name for HDF5 link
}
\details{
If \code{name} contains any of "", \code{NA} or \code{NULL}, will simply 
return \code{"/"}.
}
\examples{
h5AbsLinkName("ggg")
h5AbsLinkName("ggg/ddd")
h5AbsLinkName(NA)
h5AbsLinkName("")
h5AbsLinkName(NULL)

}
