% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combined_mxPBF.R
\name{mxPBF_combined}
\alias{mxPBF_combined}
\title{Change Point Detection in Mean Structure using Maximum Pairwise Bayes Factor (mxPBF)}
\usage{
mxPBF_combined(
  given_data,
  nws,
  alps,
  a0 = 0.01,
  b0 = 0.01,
  FPR_want = 0.05,
  n_sample = 300,
  n_cores = 1
)
}
\arguments{
\item{given_data}{An \eqn{(n \times p)} data matrix representing \eqn{n} observations and \eqn{p} variables.}

\item{nws}{A set of window sizes for change point detection.}

\item{alps}{A grid of alpha values used in the empirical False Positive Rate (FPR) method.}

\item{a0}{A hyperparameter \eqn{a_0} used in the mxPBF (default: 0.01).}

\item{b0}{A hyperparameter \eqn{b_0} used in the mxPBF (default: 0.01).}

\item{FPR_want}{Desired False Positive Rate for selecting alpha, used in the empirical FPR method (default: 0.05).}

\item{n_sample}{Number of simulated samples to estimate the empirical FPR, used in the empirical FPR method (default: 300).}

\item{n_cores}{Number of threads for parallel execution via OpenMP (default: 1).}
}
\value{
A list provided. Each element in the list contains: \describe{
\item{Result_cov}{A list result from the \code{mxPBF_cov()} function.}
\item{Result_mean}{A list result from the \code{mxPBF_mean()} function applied to each segmented data.}
\item{Change_points_cov}{Locations of detected change points identified by \code{mxPBF_cov()} function.}
\item{Change_points_mean}{Locations of detected change points identified by \code{mxPBF_mean()} function.}
}
}
\description{
This function detects change points in both mean and covariance structure of multivariate Gaussian data using the Maximum Pairwise Bayes Factor (mxPBF).
The function selects alpha that controls the empirical False Positive Rate (FPR), as suggested in the paper.
The function conducts a multiscale approach using the function.
}
\examples{
\donttest{
nws <- c(25, 60, 100)
alps <- seq(1,10,0.05)
## H0 data
mu1 <- rep(0,10)
sigma1 <- diag(10)
X <- mvrnorm_cpp(500, mu1, sigma1)
res1 <- mxPBF_combined(X, nws, alps)

## H1 data
mu2 <- rep(1,10)
sigma2 <- diag(10)
for (i in 1:10) {
  for (j in i:10) {
    if (i == j) {
    next
    } else {
    cov_value <- rnorm(1, 1, 1)
    sigma2[i, j] <- cov_value
    sigma2[j, i] <- cov_value
    }
  }
}
sigma2 <- sigma2 + (abs(min(eigen(sigma2)$value))+0.1)*diag(10) # Make it nonsingular
Y1 <- mvrnorm_cpp(150, mu1, sigma1)
Y2 <- mvrnorm_cpp(150, mu2, sigma1)
Y3 <- mvrnorm_cpp(200, mu2, sigma2)
Y <- rbind(Y1, Y2, Y3)
res2 <- mxPBF_combined(Y, nws, alps)
}

}
