% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strat.R
\name{strat_interim}
\alias{strat_interim}
\title{Adjust a subspace stratified design at interim.}
\usage{
strat_interim(start, sub_stageone)
}
\arguments{
\item{start}{An initialized stratified design as returned by \code{strat_start()}.}

\item{sub_stageone}{The subtypes observed for the patients accrued in stage 1.}
}
\value{
A list returning the arguments of the function and the preliminary design of a stratified trial adjusted at interim.
}
\description{
Adjust a subspace stratified design at interim.
}
\examples{
p0_sub <- c(0.1, 0.3, 0.5)
p1_sub <- c(0.3, 0.5, 0.7)
distr_sub <- c(1/3, 1/3, 1/3)
start <- strat_start(p0_sub, p1_sub, distr_sub)
n1 <- start$des_start[2]
subone <- sample(c(1,2,3), n1, TRUE)
strat_interim(start, subone)
}
