% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/united.R
\docType{data}
\name{gecco}
\alias{gecco}
\title{GECCO Challenge 2018 – Water Quality Time Series}
\format{
A list of time series.
}
\source{
GECCO Challenge 2018 (legacy challenge page unavailable)
}
\usage{
data(gecco)
}
\description{
Benchmark time series for water quality monitoring composed of
multiple sensors and an associated binary event label. This dataset
supports research in anomaly and event detection for environmental data
streams. See \href{https://github.com/cefet-rj-dal/united}{cefet-rj-dal/united}
for usage guidance and links to the preprocessing steps used to build the
package-ready object. Labels available: Yes.
}
\details{
This package ships a mini version of the dataset. Use loadfulldata() to download and load the full dataset from the URL stored in attr(url).
}
\examples{
data(gecco)
# Select the first univariate series and inspect
series <- gecco[[1]]
summary(series$value)
# Plot values with event markers
plot(ts(series$value), main = names(gecco)[1], ylab = "value")
}
\references{
Genetic and Evolutionary Computation Conference (GECCO), Association for Computing Machinery (ACM).
See also: Chandola, V., Banerjee, A., & Kumar, V. (2009). Anomaly detection:
A survey. ACM Computing Surveys, 41(3), 1–58.
}
\keyword{datasets}
