% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcp_cf_ets.R
\name{hcp_cf_ets}
\alias{hcp_cf_ets}
\title{Change Finder using ETS}
\usage{
hcp_cf_ets(sw_size = 7)
}
\arguments{
\item{sw_size}{Integer. Sliding window size for smoothing/statistics.}
}
\value{
\code{hcp_cf_ets} object.
}
\description{
Change-point detection by modeling residual deviations with ETS and applying
a second-stage smoothing and thresholding, inspired by ChangeFinder
\url{doi:10.1109/TKDE.2006.1599387}. Wraps ETS from the \code{forecast} package.
}
\examples{
library(daltoolbox)

# Load change-point example data
data(examples_changepoints)

# Use a simple example
dataset <- examples_changepoints$simple
head(dataset)

# Configure ChangeFinder-ETS detector
model <- hcp_cf_ets()

# Fit the model
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Show detected change points
print(detection[(detection$event),])

}
