% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_dem.R
\name{sim_dem}
\alias{sim_dem}
\title{Simulates a fractal DEM}
\usage{
sim_dem(
  L,
  smoothness,
  H,
  R,
  plot = FALSE,
  prop = 0.1,
  n = 100,
  method = "area",
  parallel = FALSE
)
}
\arguments{
\item{L}{The extent.}

\item{smoothness}{A value between 0.0 and 1.0 (lower values
produce rougher DEM).}

\item{H}{Desired height range (optional).}

\item{R}{Desired rugosity value (optional).}

\item{plot}{Logical. Plot the simulated DEM during simulation? Only relevant if R is provided.}

\item{prop}{Proportion of cells that undergo smoothing at each iteration when R is provided.}

\item{n}{Number of iterations to try and reach desired R. Recommended to adapt R and H instead of increasing n if simulation fails.}

\item{method}{The method to be used for rugosity calculation in case R is given. Can be "hvar" or "area"}

\item{parallel}{Logical. Use parallel processing? Defaults to FALSE. Only relevant if method = "hvar".}
}
\value{
Digital elevation model of class RasterLayer.
}
\description{
Simulates z-values based on the Diamond-square algorithm.
}
\details{
Warning: this function gets slow for n > 128.
If H is provided, the simulated DEM is rescaled based on the value for H.
If R is provided, a DEM is simulated using the same algorithm based on R, H, and the predicted D based on \code{\link[=rdh_theory]{rdh_theory()}}, while smoothness is ignored.
From that first simulated DEM, R is calculated and the DEM undergoes smoothing at each iteration until the rugosity approximates the inputted R.
Argument prop defined the proportion of random cells of the DEM that are smoothed by averaging the z values of cell and neighboring cells at each iteration.
Caution: When R is provided, the DEM may become increasingly less fractal as it is modified at each iteration.
}
\examples{
library(raster)
dem <- sim_dem(L = 32, smoothness = 0.5)
plot(dem)
dem <- sim_dem(L = 32, smoothness = 0.2, H = 20)
plot(dem)
}
