% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropy.R
\name{entropy_1d}
\alias{entropy_1d}
\title{1D Entropy}
\usage{
entropy_1d(x, grid_size, relative = FALSE)
}
\arguments{
\item{x}{A numeric vector.}

\item{grid_size}{Bin size in the same unit as the data.}

\item{relative}{Logical. Rescale entropy relative to the maximum entropy
given the number of grid cells? Defaults to FALSE.}
}
\value{
Entropy value.
}
\description{
Calculates entropy in 1 dimension
}
\examples{
x <- rnorm(1000, 5, 1)
entropy_1d(x, grid_size = 0.1)
entropy_1d(x, grid_size = 0.1, relative = TRUE)
y <- runif(1000, 1, 10)
entropy_1d(y, grid_size = 0.1)
entropy_1d(y, grid_size = 0.1, relative = TRUE)
}
