% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropy.R
\name{entropy}
\alias{entropy}
\title{Entropy}
\usage{
entropy(data, ...)
}
\arguments{
\item{data}{Digital elevation model of class RasterLayer, a triangular mesh of class mesh3d, or a pointcloud of class data.frame.}

\item{...}{Additional arguments depending on the data type.}
}
\value{
A value for entropy.
}
\description{
Calculates entropy based on heights, 2D, or 3D positions of points.
}
\details{
If data is a 3D pointcloud or 3D mesh, \code{\link[=entropy_3d]{entropy_3d()}} function will be applied;
if data is a 2D pointcloud,\code{\link[=entropy_2d]{entropy_2d()}} will be applied; and if data is a RasterLayer, \code{\link[=entropy_1d]{entropy_1d()}} will be applied after conversion to a vector.
See the documentation of those functions for details on the necessary arguments.
}
\examples{
entropy(mcap, bw = 0.02, grid_size = 0.01)
entropy(horseshoe, grid_size = 0.05)
}
\references{
X. Liu, Q. Ma, X. Wu, T. Hu, Z. Liu, L. Liu, Q. Guo, Y. Su (2022). A novel entropy-based method to quantify forest canopy structural complexity from multiplatform lidar point clouds. Remote Sens. Environ. 282, 113280.
}
\seealso{
\code{\link[=entropy_1d]{entropy_1d()}}

\code{\link[=entropy_2d]{entropy_2d()}}

\code{\link[=entropy_3d]{entropy_3d()}}
}
