% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organize.r
\name{h5_create_file}
\alias{h5_create_file}
\title{Create an HDF5 File}
\usage{
h5_create_file(file)
}
\arguments{
\item{file}{Path to the HDF5 file to be created.}
}
\value{
Invisibly returns \code{NULL}. This function is called for its side
effects.
}
\description{
Explicitly creates a new, empty HDF5 file.
}
\details{
This function is a simple wrapper around \code{h5_create_group(file, "/")}.
Its main purpose is to allow for explicit file creation in code.

Note that calling this function is almost always \strong{unnecessary}, as all
\code{h5lite} writing functions (like \code{\link[=h5_write]{h5_write()}} or
\code{\link[=h5_create_group]{h5_create_group()}}) will automatically create
the file if it does not exist.

It is provided as a convenience for users who prefer to explicitly create
a file before writing data to it.
}
\section{File Handling}{

\itemize{
\item If \code{file} does not exist, it will be created as a new, empty HDF5 file.
\item If \code{file} already exists and is a valid HDF5 file, this function does
nothing and returns successfully.
\item If \code{file} exists but is \strong{not} a valid HDF5 file (e.g., a text file),
an error will be thrown and the file will not be modified.
}
}

\examples{
file <- tempfile(fileext = ".h5")

# Explicitly create the file
h5_create_file(file)

if (file.exists(file)) {
  message("File created successfully.")
}

unlink(file)
}
\seealso{
\code{\link[=h5_create_group]{h5_create_group()}}, \code{\link[=h5_write]{h5_write()}}
}
