% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.median}
\alias{h2o.median}
\alias{median.H2OFrame}
\title{H2O Median}
\usage{
h2o.median(x, na.rm = TRUE)

\method{median}{H2OFrame}(x, na.rm = TRUE)
}
\arguments{
\item{x}{An H2OFrame object.}

\item{na.rm}{a logical, indicating whether na's are omitted.}
}
\value{
Returns a list containing the median for each column (NaN for non-numeric columns)
}
\description{
Compute the median of an H2OFrame.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.uploadFile(path = prostate_path)
h2o.median(prostate)
}
}
