% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_n_regression.R
\name{add_n_regression}
\alias{add_n_regression}
\alias{add_n.tbl_regression}
\alias{add_n.tbl_uvregression}
\title{Add N to regression table}
\usage{
\method{add_n}{tbl_regression}(x, location = "label", ...)

\method{add_n}{tbl_uvregression}(x, location = "label", ...)
}
\arguments{
\item{x}{(\code{tbl_regression}, \code{tbl_uvregression})\cr
a \code{tbl_regression} or \code{tbl_uvregression} table}

\item{location}{(\code{character})\cr
location to place Ns. Select one or more of \code{c('label', 'level')}.
Default is \code{'label'}.

When \code{"label"} total Ns are placed
on each variable's label row. When \code{"level"} level counts are placed on the
variable level for categorical variables, and total N on the variable's label
row for continuous.}

\item{...}{These dots are for future extensions and must be empty.}
}
\description{
Add N to regression table
}
\examples{
\dontshow{if ((identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) && gtsummary:::is_pkg_installed(c("broom", "broom.helpers"))) withAutoprint(\{ # examplesIf}
# Example 1 ----------------------------------
trial |>
  select(response, age, grade) |>
  tbl_uvregression(
    y = response,
    exponentiate = TRUE,
    method = glm,
    method.args = list(family = binomial),
    hide_n = TRUE
  ) |>
  add_n(location = "label")

# Example 2 ----------------------------------
glm(response ~ age + grade, trial, family = binomial) |>
  tbl_regression(exponentiate = TRUE) |>
  add_n(location = "level")
\dontshow{\}) # examplesIf}
}
