% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_reg.R
\name{multi_reg}
\alias{multi_reg}
\title{Multivariable Regression (Adjusted Odds, Risk, or Rate Ratios)}
\usage{
multi_reg(data, outcome, exposures, approach = "logit")
}
\arguments{
\item{data}{A data frame containing the analysis variables.}

\item{outcome}{The name of the outcome variable. Must be a character string.}

\item{exposures}{A character vector of predictor variables to include.}

\item{approach}{Modeling approach to use. One of:
- `"logit"` for logistic regression (OR),
- `"log-binomial"` for log-binomial regression (RR),
- `"poisson"` for Poisson regression (IRR),
- `"robpoisson"` for robust Poisson regression (RR),
- `"linear"` for linear regression (Beta coefficients),
- `"negbin"` for negative binomial regression (IRR).}
}
\value{
An object of class `multi_reg`, extending
  `gtsummary::tbl_regression`. Additional components can be accessed using:
  \itemize{
    \item \code{x$models}: List of fitted model objects.
    \item \code{x$model_summaries}: List of summary outputs.
    \item \code{x$reg_check}: Regression diagnostics (only for linear models).
    \item \code{x$table}: Returns the main regression table.
  }
}
\description{
Fits multivariable regression models for binary, count, or continuous
outcomes and returns a publication-ready summary table using `gtsummary`.
Depending on the specified `approach`, the function estimates
adjusted Odds Ratios (OR), Risk Ratios (RR), Incidence Rate Ratios (IRR),
or Beta coefficients.
}
\section{Accessors}{

\describe{
  \item{\code{$models}}{List of fitted model objects.}
  \item{\code{$model_summaries}}{A tibble of tidy regression
  summaries for each model.}
}
}

\examples{
if (requireNamespace("mlbench", quietly = TRUE)) {
  data(PimaIndiansDiabetes2, package = "mlbench")
  pima <- dplyr::mutate(PimaIndiansDiabetes2,
  diabetes = ifelse(diabetes == "pos", 1, 0))
  model <- multi_reg(
    data = pima,
    outcome = "diabetes",
    exposures = c("age", "mass"),
    approach = "logit"
  )
 print(model)
}

}
\seealso{
[uni_reg()], [plot_reg()], [plot_reg_combine()]
}
