% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_collapsed_gene_model_exon.R
\name{get_collapsed_gene_model_exon}
\alias{get_collapsed_gene_model_exon}
\title{Get Collapsed Gene Model Exon}
\usage{
get_collapsed_gene_model_exon(
  gencodeId,
  datasetId = "gtex_v8",
  page = 0,
  itemsPerPage = getOption("gtexr.itemsPerPage"),
  .verbose = getOption("gtexr.verbose"),
  .return_raw = FALSE
)
}
\arguments{
\item{gencodeId}{String. A Versioned GENCODE ID of a gene, e.g.
"ENSG00000065613.9".}

\item{datasetId}{String. Unique identifier of a dataset. Usually includes a
data source and data release. Options: "gtex_v8", "gtex_snrnaseq_pilot".}

\item{page}{Integer (default = 0).}

\item{itemsPerPage}{Integer (default = 250). Set globally to maximum value
100000 with \code{options(list(gtexr.itemsPerPage = 100000))}.}

\item{.verbose}{Logical. If \code{TRUE} (default), print paging information. Set
to \code{FALSE} globally with \code{options(list(gtexr.verbose = FALSE))}.}

\item{.return_raw}{Logical. If \code{TRUE}, return the raw API JSON response.
Default = \code{FALSE}}
}
\value{
A tibble. Or a list if \code{.return_raw = TRUE}.
}
\description{
This service returns the collapsed exons in the gene model of
the given gene. Gene-level and exon-level expression quantification were
based on the GENCODE annotation, collapsed to a single transcript model for
each gene using an algorithm developed by the GTEx analysis team.

By default, this service queries the models used by the latest GTEx release.

\href{https://gtexportal.org/api/v2/redoc#tag/Datasets-Endpoints/operation/get_collapsed_gene_model_exon_api_v2_dataset_collapsedGeneModelExon_get}{GTEx Portal API documentation}
}
\examples{
\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
get_collapsed_gene_model_exon(gencodeId = "ENSG00000132693.12")
\dontshow{\}) # examplesIf}
}
\seealso{
Other Datasets Endpoints: 
\code{\link{get_annotation}()},
\code{\link{get_downloads_page_data}()},
\code{\link{get_file_list}()},
\code{\link{get_full_get_collapsed_gene_model_exon}()},
\code{\link{get_functional_annotation}()},
\code{\link{get_linkage_disequilibrium_by_variant_data}()},
\code{\link{get_linkage_disequilibrium_data}()},
\code{\link{get_sample_datasets}()},
\code{\link{get_subject}()},
\code{\link{get_tissue_site_detail}()},
\code{\link{get_variant}()},
\code{\link{get_variant_by_location}()}
}
\concept{Datasets Endpoints}
