\name{roundInterims}
\alias{roundInterims}
\title{Round a gsearly design interim sample size to integer values}
\usage{roundInterims(mod, direct="u", full=FALSE)}
\description{Rounds the interim sample size to integer values.}
\arguments{
 \item{mod}{A fitted gsearly object from function \code{\link{gsearlyModel}} or
   \code{\link{gsearlyUser}}.}
 \item{direct}{Rounds interim sample sizes to nearest integer, upwards
   \code{"u"} (using \code{ceiling}) or downwards \code{"d"} (using
   \code{floor}).}
 \item{full}{Either \code{FALSE}, which provides total numbers only or
   \code{TRUE} which provides full details of numbers by groups.}
}
\value{
 Returns a matrix (or matrices, if \code{full=TRUE}) of the total sample sizes
   (and control and treatment groups, if \code{full=TRUE})  for each outcome at
   interims analyses.
}
\seealso{
 \code{\link{gsearlyModel}}, \code{\link{gsearlyUser}}
}
\examples{

 # For 90 percent power (pow), a call to gsearlyModel provides a feasible design
 fp <- c(0.0000,0.0010,0.0250)
 tn <- c(0.2400,0.7200,0.9750)
 rctdesign <- gsearlyModel(rmodel="fix", trecruit=36, s=3, tfu=c(3,6,12),
                  tinterims=c(16,31), pow=0.8,
                  cmodel="exponential", sd=20, rho=0.75, theta=10, fp=fp, tn=tn)
 rctdesign

 # Expected numbers of participants at interim analyses
 rctdesign$rdata$interims

 # Round design up to integer values
 round_rctdesign <- roundInterims(rctdesign, direct="u")
 round_rctdesign

 # Power for rounded design
 n <- rctdesign$rdata$n["total"]
 ninterims <- round_rctdesign
 cmodel <- rctdesign$idata$cmodel$corrmat
 userdesign <- gsearlyUser(trecruit=36, s=3, tfu=c(3,6,12), tinterims=c(16,31),
        ninterims=ninterims, n=n, cmodel=cmodel,
        sd=20, theta=10, fp=fp, tn=tn)
 userdesign
 userdesign$rdata$interims

}
