% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perm_gs_by_pops.R
\name{perm_gs_by_pops}
\alias{perm_gs_by_pops}
\title{Take the output of rearrange_genos and permute everyone by population}
\usage{
perm_gs_by_pops(GS, preserve_haplotypes = FALSE, preserve_individuals = FALSE)
}
\arguments{
\item{GS}{the tibble that is the output from rearrange_genos}

\item{preserve_haplotypes}{If TRUE then the Geno data is assumed phased
(first allele at an individual on one haplotype and second allele on the
other) and those haplotypes are preserved in this permutation of
genomic material amongst the founders.}

\item{preserve_individuals}{If TRUE then whole individuals are permuted
around the data set and the two gene copies at each locus are randomly
permuted within each individual.  If \code{preserve_individuals = "BY_CHROM"},
then the the two copies of each chromosome in an individual are permuted
together.  Thus a permuted individual may have two copies of one chromosome
from one individual, and two copies of another chromosome from a different
individual.  (If \code{preserve_haplotypes = TRUE} then
the gene copies are not permuted within individuals. You should only ever
use \code{preserve_haplotypes = TRUE} if you have phased data.)}
}
\value{
Returns a list of the same format as the output of \code{rearrange_genos}.
Plus one additional component. Each component of the return list is itself
an unnamed list with one component (makes it easier to use \code{bind_rows} to
create a tibble of list columns from these).  The components, once unlisted are:
\itemize{
\item \code{G}: a matrix---the original genotype data matrix
\item \code{I}: the I_meta tibble
\item \code{M}: the M_meta tibble
\item \code{G_permed}: the genotype matrix after permutation.
}
}
\description{
This is done prior to assigning random genomic fragments of individuals in the
sample to the founders of the GSP, to be dropped to the samples.
}
\examples{
# first get the output of rearrange_genos
RG <- rearrange_genos(Geno, I_meta, M_meta)

# then permute by the populations
PG <- perm_gs_by_pops(RG)
}
