% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoSample.Boundary.TTFE.R
\name{TwoSample.Boundary.TTFE}
\alias{TwoSample.Boundary.TTFE}
\title{Function to calculate the sequential rejection boundaries for the time-to-first-event (TTFE) method.}
\usage{
TwoSample.Boundary.TTFE(result, spend, calendars, alpha, planned.n, Iunit)
}
\arguments{
\item{result}{A list returned by \code{TwoSample.Z.Var.Estimator.Sequential.TTFE()}.}

\item{spend}{A Type I error spending function. This should be a function of a
single argument \code{t} (information fraction) returning cumulative alpha
spent by information fraction \code{t} (e.g., \code{OBF}).}

\item{calendars}{Numeric vector of interim analysis calendar times (in years).}

\item{alpha}{Overall two-sided Type I error rate. Default typically \code{0.05}.}

\item{planned.n}{Planned total sample size used to define the information scale.}

\item{Iunit}{Information per subject at the final analysis.}
}
\value{
A list containing:
\itemize{
  \item \code{Z.stats}: Stage-wise TTFE Z-statistics.
  \item \code{vars}: Stage-wise variance estimates.
  \item \code{raw.information}: Stage-wise information fractions.
  \item \code{TTFE.bdry}: Two-sided critical boundaries at each analysis stage.
  \item \code{TTFE.reject}: Stage-wise rejection indicators (1 = reject at that
  stage, 0 otherwise), with later stages set to 0 after the first rejection.
  \item \code{nu}: Stage-wise information fractions after handling edge cases
  (e.g., reaching 100\% information early).
  \item \code{pi}: Incremental Type I error allocated to each stage.
  \item \code{total.ns}: Total sample size contributing at each analysis stage
  (copied from \code{result}).
}
}
\description{
Constructs two-sided group sequential critical boundaries for the two-sample TTFE log-rank Z-statistics at prespecified
calendar times. The function converts stage-wise variance estimates into information fractions, allocates incremental Type
I error using a spending function, and solves for the corresponding multivariate normal critical values under the
canonical joint distribution assumption. It also returns stage-wise rejection indicators (with early stopping enforced).
}
