% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autocor.r
\name{corgram}
\alias{corgram}
\title{Calculate and Plot a Correlogram}
\usage{
corgram(y, wt = 1, maxlag = NULL, partial = FALSE, add = FALSE,
  lty = 1, xlim = NULL, ylim = NULL, xlab = NULL, ylab = NULL,
  main = NULL, ...)
}
\arguments{
\item{y}{A time series vector.}

\item{wt}{Indicator vector with zeros for values to be ignored.}

\item{maxlag}{Maximum number of lags for which the correlation is to be
calculated.}

\item{partial}{If TRUE, the partial autocorrelation function (PACF) is
plotted.}

\item{add}{If TRUE, adds a new correlogram to an existing plot.}

\item{lty}{Plotting parameters}

\item{xlim}{Plotting parameters}

\item{ylim}{Plotting parameters}

\item{xlab}{Plotting parameters}

\item{ylab}{Plotting parameters}

\item{main}{Plotting parameters}

\item{...}{Plotting parameters}
}
\value{
\code{corgram} returns a two-column matrix containing the (partial)
correlogram coordinates.
}
\description{
\code{corgram} calculates the values of a correlogram (autocorrelation
function or ACF) and plots it.
}
\examples{

y <- rnorm(100)
corgram(y)
corgram(y, partial=TRUE)
}
\author{
J.K. Lindsey
}
\keyword{hplot}
