% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{growR_run_loop}
\alias{growR_run_loop}
\title{Run growR simulations}
\usage{
growR_run_loop(modvege_environments, output_dir = "", independent = TRUE)
}
\arguments{
\item{modvege_environments}{A list of \link{ModvegeEnvironment} instances.}

\item{output_dir}{string; name of directory to which output files are to
be written. If \code{output_dir == ""} (default), no files are written.}

\item{independent}{boolean; If \code{TRUE} (default) the simulation for each
year starts with the same initial conditions, as specified in the
parameters of the modvege_environments. If \code{FALSE}, initial conditions
are taken as the final state values of the simulation of the previous
year.}
}
\value{
A list of the format \verb{[[run]][[year]]} containing clones of
the \link{ModvegeSite} instances that were run. Also write to files, if
\emph{output_dir} is nonempty.
}
\description{
Start the loop over runs specified in the config file.
}
\details{
By default, returns an empty list but writes output to the output files
as specified in the \emph{site_name} and \emph{run_name} fields of the supplied
\link{ModvegeEnvironment} instances. Change this behaviour through the
\code{write_files} and \code{store_results} arguments.
}
\examples{
env1 = create_example_environment(site = "posieux")
env2 = create_example_environment(site = "sorens")

growR_run_loop(c(env1, env2), output_dir = "")

}
