% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treepcor.R
\name{treepcor}
\alias{treepcor}
\title{Define a tree used to model correlation matrices
using a shared latent variables method represented by a tree,
whose nodes represent the two kind of variables:
children and parent. See \linkS4class{treepcor}.}
\usage{
treepcor(...)
}
\arguments{
\item{...}{a list of formula used as relationship
to define a three for correlation modeling, see \code{\link[=treepcor]{treepcor()}}.
Parent nodes shall be in the right side while children
(or parent with a parent) in the left side.}
}
\value{
a \code{treepcor} object
}
\description{
Define a tree used to model correlation matrices
using a shared latent variables method represented by a tree,
whose nodes represent the two kind of variables:
children and parent. See \linkS4class{treepcor}.
}
\details{
The children variables are those with an ancestor (parent),
and are identified as \code{c1}, ..., \code{cn}, where \code{n} is the
total number of children variables.
The variables are identified as \code{p1}, ..., \code{pm},
where the \code{m} is the number of parent variables.
The main parent (fist) should be identified as \code{p1}.
Parent variables (except \code{p1}) have an ancestor,
which is a parent variable.
}
\examples{
g1 <- treepcor(p1 ~ c1 + c2 - c3)
g1
summary(g1)
plot(g1)
prec(g1)
prec(g1, theta = 0)

g2 <- treepcor(p1 ~ c1 + c2 + p2,
          p2 ~ c3 - c4)
g2
summary(g2)
plot(g2)
prec(g2)
prec(g2, theta = c(0, 0))

g3 <- treepcor(p1 ~ -p2 + c1 + c2,
          p2 ~ c3)
g3
summary(g3)
plot(g3)
prec(g3)
prec(g3, theta = c(0,0))
}
