% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeGP.R
\name{writeGP}
\alias{writeGP}
\alias{readGP}
\title{Export/import graph.}
\usage{
writeGP(graph, file)

readGP(file)
}
\arguments{
\item{graph}{[\code{\link{grapherator}}]\cr
Graph.}

\item{file}{[\code{character(1)}]\cr
Path to file where the graph shall be stored (for \code{\link{writeGP}})
or which contains the graph to be imported (for \code{link{readGP}}).}
}
\value{
Function \code{\link{writeGP}} silently returns the passed filename
\code{file} whereas \code{\link{writeGP}} returns a \code{grapherator} object.
}
\description{
Given a \code{grapherator} graph function \code{\link{writeGP}}
saves the graph to a file. Function \code{\link{readGP}} imports a graph
given a filename.
}
\details{
Instances are stored in a format similar to the one used
by Cardoso et al. in their MOST project. Note that all values in each line are separated by comma.
First line contains four integer values: number of nodes n, number of edges m,
number of clusters cl and number of weights p per edge.
The second line contains the weight types.
The third line contains the node types.
The next n lines contain the node coordinates.
In case of a clustered instance the next line contains the node to cluster
membership mapping.
The last m lines contain the following information each:
i,j,w1(i,j),...,wp(i,j)
I.e., each two node numbers i and j followed by the p weights of the edge
(i, j).
}
\examples{
g = graph(0, 100)
g = addNodes(g, n = 25, generator = addNodesGrid)
g = addEdges(g, generator = addEdgesGrid)
g = addWeights(g, generator = addWeightsRandom, method = runif, min = 5, max = 100, to.int = TRUE)
g = addWeights(g, generator = addWeightsRandom, method = runif, min = 10, max = 100, to.int = TRUE)
\dontrun{
filename = tempfile()
writeGP(g, file = filename)
g2 = readGP(file = filename)
unlink(filename)
do.call(gridExtra::grid.arrange, c(plot(g), plot(g2), list(nrow = 2)))
}
}
