% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.character.R
\name{as.character.grapherator}
\alias{as.character.grapherator}
\title{Graph string representation.}
\usage{
\method{as.character}{grapherator}(x, ...)
}
\arguments{
\item{x}{[\code{\link{grapherator}}]\cr
Graph.}

\item{...}{[any]\cr
Not used at the moment.}
}
\value{
[\code{character(1)}]
}
\description{
Given a \code{\link{grapherator}} object the function returns
a string representation. Basically this is a concatenation of meta data, node,
edge and weight generator types of the following format:
N<n.nodes>-E<n.edges>-C<n.clusters>-W<n.weights>---<node-types>---<edge-types>---<weight-types>
where n.x is the number of x of the graph.
}
\examples{
g = graph(lower = c(0, 0), upper = c(100, 100))
g = addNodes(g, n = 3, generator = addNodesUniform)
g = addNodes(g, n = 14, by.centers = TRUE, generator = addNodesUniform,
  lower = c(0, 0), upper = c(10, 10))
g = addEdges(g, generator = addEdgesWaxman, alpha = 0.2,
  beta = 0.2, type = "intracluster")
g = addEdges(g, generator = addEdgesDelauney, type = "intercenter")
g = addWeights(g, generator = addWeightsCorrelated, rho = -0.9)
g = addWeights(g, generator = addWeightsDistance, method = "euclidean")
as.character(g)
}
