% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{addEdgesToPlot}
\alias{addEdgesToPlot}
\title{Highlight edges in graph.}
\usage{
addEdgesToPlot(x, g, edge.list, ...)
}
\arguments{
\item{x}{[\code{\link[ggplot2]{ggplot}}]\cr
Coordinate plot generated via \code{\link{plot.grapherator}}.}

\item{g}{[\code{\link[grapherator]{grapherator}}]\cr
Graph.}

\item{edge.list}{[\code{matrix}]\cr
Matrix of edges (each column is one edge).}

\item{...}{[any]\cr
Arguments passed down to \code{\link[ggplot2]{geom_segment}}.}
}
\value{
[\code{\link[ggplot2]{ggplot}}] Modified \code{x}.
}
\description{
Highlights edges in coordinate plot.
}
\examples{
\dontrun{
g = graph(0, 100)
g = addNodes(g, n = 10, generator = addNodesUniform)
g = addEdges(g, generator = addEdgesComplete)
pl = plot(g)$pl.coords
el = matrix(c(1, 2, 1, 3, 4, 5, 3, 4), nrow = 2L)
pl = addEdgesToPlot(pl, g, el)
print(pl)
}
}
