% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{mpg-class}
\alias{mpg-class}
\title{The \code{mpg} class}
\description{
The \code{mpg} class
}
\section{Slots}{

\describe{
\item{\code{mpg}}{The minimum planar graph as class \code{igraph}.}

\item{\code{patchId}}{The input \code{patch} raster with patch cells assigned to
their id (\code{RasterLayer}).}

\item{\code{voronoi}}{The Voronoi tessellation of the patches and resistance
surface (\code{RasterLayer}).}

\item{\code{lcpPerimWeight}}{The paths of the links between patches and their
accumulated costs (\code{RasterLayer}).}

\item{\code{lcpLinkId}}{The paths of the links between patches and their id (\code{RasterLayer}).}

\item{\code{mpgPlot}}{A \code{RasterLayer} version of the \code{mpg}, which can be
easily plotted to visualize the MPG.

The \code{mpg} slot contains useful vertex and edge attributes.
Vertex attributes give attributes of patches including patch area,
the area of patch edges, the core area of each patch, and the coordinates
of the patch centroid.
All areal measurements are given as raster cell counts.
Edge attributes give attributes of the graph links including link
weights giving accumulated resistance/least-cost path distance,
Euclidean distance, and the start and end coordinates of each link.}
}}

\author{
Alex Chubaty and Paul Galpern
}
