% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/service-cohere.R
\name{create_chat_cohere}
\alias{create_chat_cohere}
\title{Create a chat with the Cohere Chat API}
\usage{
create_chat_cohere(
  prompt,
  chat_history = NULL,
  connectors = NULL,
  model = "command",
  api_key = Sys.getenv("COHERE_API_KEY")
)
}
\arguments{
\item{prompt}{A string containing the user message.}

\item{chat_history}{A list of previous messages for context, if any.}

\item{connectors}{A list of connector objects, if any.}

\item{model}{A string representing the Cohere model to be used, defaulting to "command".
Other options include "command-light", "command-nightly", and "command-light-nightly".}

\item{api_key}{The API key for accessing the Cohere API, defaults to the
COHERE_API_KEY environment variable.}
}
\value{
The response from the Cohere Chat API containing the model's reply.
}
\description{
This function submits a user message to the Cohere Chat API,
potentially along with other parameters such as chat history or connectors,
and returns the API's response.
}
