% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpkg-srs.R
\name{gpkg_spatial_ref_sys}
\alias{gpkg_spatial_ref_sys}
\alias{gpkg_list_srs}
\alias{gpkg_create_spatial_ref_sys}
\alias{gpkg_add_spatial_ref_sys}
\alias{gpkg_delete_spatial_ref_sys}
\title{GeoPackage Spatial Reference System}
\usage{
gpkg_spatial_ref_sys(x)

gpkg_list_srs(x, column_name = "srs_id")

gpkg_create_spatial_ref_sys(x, default = TRUE, query_string = FALSE)

gpkg_add_spatial_ref_sys(
  x,
  srs_name = "",
  srs_id = NULL,
  organization = "",
  organization_coordsys_id = 0L,
  definition = "",
  description = "",
  query_string = FALSE
)

gpkg_delete_spatial_ref_sys(x, srs_id = NULL)
}
\arguments{
\item{x}{A geopackage object}

\item{column_name}{Default: \code{"srs_id"}}

\item{default}{\emph{logical} or \emph{character}. If \code{TRUE}, or one or more of \code{"cartesian"}, \code{"geographic"}, or \code{"crs84"}, then these default Spatial Reference Systems are added.}

\item{query_string}{\emph{logical}. Return SQL queries without executing? Default: \code{FALSE}}

\item{srs_name}{\emph{character}. Spatial Reference System Name, for example \code{"WGS 84 geodetic"}}

\item{srs_id}{\emph{integer}. Spatial Reference System ID, for example \code{4326L}}

\item{organization}{\emph{character}. Organization, for example \code{"EPSG"}}

\item{organization_coordsys_id}{\emph{integer}. Organization Coordinate System ID, for example \code{4326L}}

\item{definition}{\emph{character}. WKT2019 Coordinate Reference System description string}

\item{description}{\emph{character}. Description}
}
\value{
\code{gpkg_spatial_ref_sys()}: \emph{data.frame}

\code{gpkg_list_srs()}: \emph{vector} of values from specified \code{column_name}

\code{gpkg_create_spatial_ref_sys()}: \emph{integer}. Result of running sequential \code{gpkg_execute()} statements. This method is run for the side-effect of creating the table if needed, and adding any "default" records.

\code{gpkg_add_spatial_ref_sys()}: \emph{integer} result of executing SQL statement

\code{gpkg_delete_spatial_ref_sys()}: \emph{integer} result of executing SQL statement
}
\description{
GeoPackage Spatial Reference System
}
