% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cli_integration.R
\name{goose_test_cli}
\alias{goose_test_cli}
\title{Test if Goose CLI is Working}
\usage{
goose_test_cli(verbose = TRUE, timeout = 60)
}
\arguments{
\item{verbose}{Logical, whether to print status messages}

\item{timeout}{Numeric, timeout in seconds for the test query (default 60).
Increase this if authentication prompts require more time.}
}
\value{
Logical, TRUE if CLI works, FALSE otherwise
}
\description{
Tests if Goose CLI is properly configured and can execute queries.
This is especially useful for Block employees who have CLI configured
but don't need to provide API keys in R.
}
\examples{
\dontrun{
# Check if CLI works
if (goose_test_cli()) {
  # Ready to use goose_ask() etc.
  response <- goose_ask("Hello!")
} else {
  # May need configuration
  goose_configure(provider = "openai", model = "gpt-4", api_key = "key")
}

# Allow more time for authentication
goose_test_cli(timeout = 120)
}
}
