% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zones.R
\name{gtm_zones_get}
\alias{gtm_zones_get}
\title{List a single zone in a workspace}
\usage{
gtm_zones_get(account_id, container_id, workspace_id, zone_id)
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}

\item{workspace_id}{Workspace Id}

\item{zone_id}{Zone Id}
}
\description{
This will return a list with the settings of a single zone.
If you want to get the information for all zones, use \code{gtm_zones_list}
}
\examples{

\dontrun{
accountId <- 1234567
containerId <- 7654321
workspaceId <- 11
zoneId <- 12

zone <- gtm_zones_get(accountId, containerId, workspaceId, zoneId)
}

}
\seealso{
\url{https://developers.google.com/tag-platform/tag-manager/api/v2/reference/accounts/containers/workspaces/zones/get}

Other zone functions: 
\code{\link{gtm_zones_create}()},
\code{\link{gtm_zones_delete}()},
\code{\link{gtm_zones_list}()},
\code{\link{gtm_zones_revert}()},
\code{\link{gtm_zones_update}()}
}
\concept{zone functions}
