% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/containers.R
\name{gtm_containers_update}
\alias{gtm_containers_update}
\title{Updates a GTM Container}
\usage{
gtm_containers_update(
  account_id,
  container_id,
  name,
  type = c("amp", "androidSdk5", "iosSdk5", "web", "server"),
  domain_name = "",
  notes = ""
)
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}

\item{name}{Container Name}

\item{type}{Container Use Type, one of web, iosSdk5, androidSdk5, amp or server}

\item{domain_name}{List of domain names associated with the Container.}

\item{notes}{Container Notes.}
}
\description{
This updates a GTM Container.
Although you can't change the type of container, it is still required for this function to work.
}
\examples{
\dontrun{

accountId <- 1234567
containerId <- 7654321
containers <- gtm_containers_update(accountId, containerId, 'New Container Name', 'amp')

}

}
\seealso{
\url{https://developers.google.com/tag-platform/tag-manager/api/v2/reference/accounts/containers/update}

Other container functions: 
\code{\link{gtm_containers_create}()},
\code{\link{gtm_containers_delete}()},
\code{\link{gtm_containers_get}()},
\code{\link{gtm_containers_list}()}
}
\concept{container functions}
