% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/googlepublicdata.r, R/pdemethods.r
\name{dspl-methods}
\alias{dspl-methods}
\alias{print.dspl}
\alias{summary.dspl}
\alias{print.dspl}
\alias{summary.dspl}
\title{Print and summarize dspl objects}
\usage{
\method{print}{dspl}(x, path = NULL, replace = FALSE, quiet = FALSE, ...)

\method{summary}{dspl}(object, ...)
}
\arguments{
\item{x}{An object of class \code{dspl} to be printed.}

\item{path}{String. Output path where to save the XML DSPL file.}

\item{replace}{Logical. If \code{path} exists, \code{TRUE} would replace the
file.}

\item{quiet}{Whether or not to print information on the screen}

\item{\dots}{arguments passed on to \code{\link{cat}} (\code{print.dspl})}

\item{object}{An object of class \code{dspl} to be summarized.}
}
\value{
\item{list("print.dspl")}{ None (invisible \code{NULL}).}

\item{list("summary.dspl")}{Returns the class attributes and a list
containing as defined by \code{\link{dspl}} function. For more information
see its value section.}
}
\description{
Methods to print and summarize \code{dspl} class objects
}
\examples{

  \dontrun{
    # Parsing some xlsx files at "my stats folder"
    mydspl <- dspl(path="my stats folder/")
    
    # Checking the summary of the data bundle
    summary(mydspl)
    
    # Writing the DSPL XML definition into a file
    outputfile <- tempfile()
    print(mydspl, path=outputfile)
    
  }
}
\seealso{
See also \code{\link{dspl}}
}
\author{
George G. Vega Yon
}
\keyword{methods}
