% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ellipse_by_genotype.R
\name{ellipse.by.gen}
\alias{ellipse.by.gen}
\title{Ellipse best fit plot}
\usage{
ellipse.by.gen(
  qt1,
  qt2,
  g,
  trait_name1 = "qt trait 1",
  trait_name2 = "qt trait 2",
  title = "",
  sample_size = 500
)
}
\arguments{
\item{qt1}{A numeric vector.}

\item{qt2}{A numeric vector.}

\item{g}{An integer vector.}

\item{trait_name1}{A string.}

\item{trait_name2}{A string.}

\item{title}{A string.}

\item{sample_size}{A positive integer.}
}
\value{
A scatter plot.
}
\description{
This tool creates a scatter plot along with regression lines. Additionally it finds and plots the best ellipses that fit the data.
}
\examples{
n_val <- 10000L
geno_vec <- c(rep(0, n_val), rep(1, n_val), rep(2, n_val))
qt_g0 <- MASS::mvrnorm(n_val, mu = c(0, 0), Sigma = matrix(c(0.93, 0.88, 0.88, 0.92), ncol = 2))
qt_g1 <- MASS::mvrnorm(n_val, mu = c(0, 0), Sigma = matrix(c(0.98, 0.88, 0.88, 0.90), ncol = 2))
qt_g2 <- MASS::mvrnorm(n_val, mu = c(0, 0), Sigma = matrix(c(1.57, 0.81, 0.81, 0.59), ncol = 2))
qt_vec <- rbind(qt_g0, qt_g1)
qt_vec <- rbind(qt_vec, qt_g2)
res <- ellipse.by.gen(qt_vec[, 1], qt_vec[, 2], geno_vec)
}
