% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmnl.methods.R
\name{AIC.gmnl}
\alias{AIC.gmnl}
\alias{BIC.gmnl}
\title{Akaike's Information Criterion}
\usage{
\method{AIC}{gmnl}(object, ..., k = 2)

\method{BIC}{gmnl}(object, ...)
}
\arguments{
\item{object}{a fitted model of class \code{gmnl}.}

\item{...}{additional arguments to be passed to or from other functions.}

\item{k}{a numeric value, use as penalty coefficient for number of parameters
in the fitted model.}
}
\value{
A numeric value with the corresponding AIC or BIC value.
}
\description{
Calculate the Akaike's information Criterion (AIC) or the Bayesian
information Criterion (BIC) for an object of class \code{gmnl}.
}
\details{
For more information see \code{\link[stats]{AIC}} or \code{\link[stats]{BIC}}
}
\examples{

## Estimate MNL model
data("TravelMode", package = "AER")
library(mlogit)
TM <- mlogit.data(TravelMode, choice = "choice", shape = "long", 
                 alt.levels = c("air", "train", "bus", "car"), chid.var = "individual")
                 
mnl <- gmnl(choice ~ wait + vcost + travel + gcost | 0 , data = TM)
AIC(mnl)
BIC(mnl)
}
\seealso{
\code{\link[gmnl]{gmnl}} for the estimation of multinomial logit models with observed and unobserved individual heterogeneity.
}
