#' Subset of 221 children from the 1979 National Longitudinal Survey of Youth
#' 
#' These data are wave-based such that each child’s Peabody Individual Assessment 
#' Test (PIAT) reading and antisocial behavior scores were measured at four waves 
#' in two-year intervals. 
#' 
#' @format A data frame with 221 rows and 14 variables:
#' \describe{
#'   \item{id}{Unique identifier}
#'   \item{mom_age}{Mother’s age when the child was born }
#'   \item{home_cog}{Measure of cognitive stimulation provided at home}
#'   \item{home_emo}{Measure of emotional support provided at home}
#'   \item{read0}{PIAT reading score at wave 1}
#'   \item{read1}{PIAT reading score at wave 2}
#'   \item{read2}{PIAT reading score at wave 3}
#'   \item{read3}{PIAT reading score at wave 4}
#'   \item{anti0}{Antisocial behavior score at wave 1}
#'   \item{anti1}{Antisocial behavior score at wave 2}
#'   \item{anti2}{Antisocial behavior score at wave 3}
#'   \item{anti3}{Antisocial behavior score at wave 4}
#' }
#' @source \url{https://github.com/MultiLevelAnalysis/Datasets-third-edition-Multilevel-book/tree/master/chapter%205/Curran}
"nlsy"