% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_object.r
\name{download_object}
\alias{download_object}
\alias{download_object.numeric}
\alias{download_object.list}
\alias{download_object_global}
\title{Download data for object batch}
\usage{
download_object(object, control = 1, locations = gt.env$countries, ...)

\method{download_object}{numeric}(object, control = 1, locations = gt.env$countries, ...)

\method{download_object}{list}(object, control = 1, locations = gt.env$countries, ...)

download_object_global(object, control = 1, ...)
}
\arguments{
\item{object}{Object batch for which the data is downloaded. Object
of type \code{numeric} or object of type \code{list} containing single
object of type \code{numeric}.}

\item{control}{Control batch that is used for mapping. Object of type
\code{numeric}. Defaults to \code{1}.}

\item{locations}{List of countries or regions for which the data is
downloaded. Refers to lists generated in \code{start_db}. Defaults to
\code{countries}.}

\item{...}{Arguments that are passed on to the \code{gtrendsR::gtrends} function.}
}
\value{
Message that data was downloaded successfully. Data is written
to table \emph{data_object}.
}
\description{
The function downloads search volumes from Google Trends for an object batch
(\emph{batch_o}) and one keyword from a control batch (\emph{batch_c}) in a
set of \emph{locations}. Data is automatically written to table
\emph{data_object}. For \code{download_object_global} the input
\emph{location} is automatically set to \emph{world}.
}
\details{
Downloads through the Google Trends API are made through
\code{gtrendsR::gtrends}. Each object batch can consist of up to four
keywords and is predefined in tables \emph{batch_keywords} and
\emph{batch_time} through \code{add_keywords}. In addition, one control
keyword is added to each object batch. The control keyword then allows a
mapping between search volumes for control keywords stored in
\emph{data_control} and search volumes for object keywords. The download for
a single keyword batch for a single location takes about 30 seconds. This
includes a randomized waiting period of 5-10 seconds between downloads.
Depending on the frequency of downloads, Google Trends might block users
for some time. In this case, \code{download_object} waits 60 minutes
before it retries the download.
}
\section{Warning}{

We advise against the usage of \emph{category codes} in
downloads. If you use \emph{categories} to narrow the context of keyword usage,
these categories are applied to \strong{ALL} keywords in the batch. This applies
to \emph{control} keywords as well as \emph{object} keywords and can result in
unintended behavior.
}

\examples{
\dontrun{
download_object(
  object = 1,
  locations = countries
)
download_object(
  object = as.list(1:5),
  locations = countries
)
}

}
\seealso{
\itemize{
\item \code{\link[=example_object]{example_object()}}
\item \code{\link[gtrendsR:gtrends]{gtrendsR::gtrends()}}
}
}
