% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overglm3.R
\name{estequa.zeroinflation}
\alias{estequa.zeroinflation}
\title{Estimating Equations in Regression Models to deal with Zero-Excess in Count Data}
\usage{
\method{estequa}{zeroinflation}(object, submodel = c("counts", "zeros"), ...)
}
\arguments{
\item{object}{an object of the class \emph{zeroinflation}.}

\item{submodel}{an (optional) character string which allows to specify the model: "counts" or "zeros". By default,
\code{submodel} is set to "counts".}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A vector with the values of the estimating equations evaluated at the parameter estimates and the observed data.
}
\description{
Computes the estimating equations evaluated at the parameter estimates and the observed data for regression models to deal with zero-excess in count data.
}
\examples{
####### Example 1: Roots Produced by the Columnar Apple Cultivar Trajan
data(Trajan)
fit1 <- zeroalt(roots ~ photoperiod, family="nbf(log)", zero.link="logit", data=Trajan)
estequa(fit1)

fit1a <- zeroinf(roots ~ photoperiod, family="nbf(log)", zero.link="logit", data=Trajan)
estequa(fit1a)

####### Example 2: Self diagnozed ear infections in swimmers
data(swimmers)
fit2 <- zeroalt(infections ~ frequency | location, family="nb1(log)", data=swimmers)
estequa(fit2)

fit2a <- zeroinf(infections ~ frequency | location, family="nb1(log)", data=swimmers)
estequa(fit2a)

####### Example 3: Article production by graduate students in biochemistry PhD programs
bioChemists <- pscl::bioChemists
fit3 <- zeroalt(art ~ fem + kid5 + ment, family="nb1(log)", data = bioChemists)
estequa(fit3)

fit3a <- zeroinf(art ~ fem + kid5 + ment | ment, family="nb1(log)", data = bioChemists)
estequa(fit3a)
}
