% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{residuals.glmmTMB}
\alias{residuals.glmmTMB}
\alias{deviance.glmmTMB}
\title{Compute residuals for a glmmTMB object}
\usage{
\method{residuals}{glmmTMB}(
  object,
  type = c("response", "pearson", "working", "deviance", "dunn-smyth"),
  re.form = NULL,
  ...
)

\method{deviance}{glmmTMB}(object, ...)
}
\arguments{
\item{object}{a \dQuote{glmmTMB} object}

\item{type}{(character) residual type}

\item{re.form}{\code{NULL} to specify individual-level predictions; \code{~0} or \code{NA} to specify population-level predictions (i.e., setting all random effects to zero)}

\item{\dots}{for method compatibility (unused arguments will throw an error)}
}
\description{
Compute residuals for a glmmTMB object
}
\details{
\itemize{
\item Residuals are computed based on predictions of type "response",
i.e. equal to the conditional mean for non-zero-inflated models and to \code{mu*(1-p)}
for zero-inflated models
\item Computing deviance residuals depends on the implementation of the \code{dev.resids}
function from the object's \code{family} component; at present this returns \code{NA} for most
"exotic" families (i.e. deviance residuals are currently only
implemented for families built into base R plus \code{nbinom1}, \code{nbinom2}). Deviance residuals are based on the conditional distributions only, i.e. ignoring zero-inflation components.
\item Deviance is computed as the sum of squared deviance residuals, so is available only
for the families listed in the bullet point above. See \link[lme4]{deviance.merMod} for more
details on the definition of the deviance for GLMMs.
\item for distributions in the exponential dispersion family (Gaussian, Poisson, binomial, Gamma), for models with a fixed dispersion parameter (Poisson, binomial) or constant \code{dispformula} component, reported Pearson residuals are only scaled by a factor proportional to the residual standard deviation (for compatibility with base R); divide these values by \code{sigma(fitted_model)} to get raw residuals scaled by the standard deviation. For all other distributions/models, Pearson residuals are scaled by the residual standard deviation. (The beta-binomial currently returns unscaled residuals.)
}
}
