% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmFitMiss-package.R
\docType{package}
\name{glmfitmiss-package}
\alias{glmfitmiss}
\alias{glmfitmiss-package}
\alias{glmFitMiss-package}
\title{glmfitmiss: Fitting Binary Regression Models with Missing Data}
\description{
The glmfitmiss package provides functions for fitting binary regression models in the presence of missing data in both response variable level and covariate levels. The package includes likelihood-based methods, primarily based on the EM algorithm by Ibrahim (1990) for handling missing data mechanisms. Bias-reducing adjusted score approaches introduced by Firth (1993) are also incorporated in all the supported methods.
}
\details{
This package enhances the accuracy of binary regression modeling in the presence of missing data by incorporating Ibrahim (1990) EM algorithm and Firth (1993) bias-reducing adjusted score methods.

The main functions in this package are:
\itemize{
\item \code{\link{emBinRegMAR}}: Fits a binary regression model with missing categorical covariates. Assumes missing data are Missing at Random (MAR).
\item \code{\link{emBinRegNonIG}}: Fits a binary regression model with missing responses that are nonignorable based on Ibrahim and Lipsitz (1996).
\item \code{\link{emBinRegMixedMAR}}: Fits a binary regression model with missing responses and covariates, accounting for the non-ignorable missing responses assumption and Missing at Random (MAR) missing covariates.
\item \code{\link{logRegMAR}}: Fits a logistic regression model (binary regression with a link=logit) with missing categorical covariates that are Missing at Random (MAR).
}

The other functions and data included in this package are
\itemize{
\item \code{\link{emforbeta}}: The function to fit binary regression models with missing categorical covariates is implemented using a likelihood-based method, specifically the EM algorithm proposed by Ibrahim (1990).
\item \code{\link{est}}: Example using Eastern Cooperative Oncology Group clinical trial.
\item \code{\link{meningitis}}: Example using Meningococcal Disease Data.
\item \code{\link{metastmelanoma}}: Example from a cancer clinical trial metastatic melanoma -- Kirkwood et al. (1996).
\item \code{\link{emyxmiss}}: The main function fits binary regression models while accounting for missing responses and missing categorical covariates. This function implements a novel likelihood-based method using the EM algorithm. For more information, refer to the work by Pradhan, Nychka, and Bandyopadhyay (2025).
\item \code{\link{meningitis60ymis}}: Meningococcal Disease Data with missing response variable.
\item \code{\link{llkmiss}}: Log-likelihood function for models with missing data with out using EM-algorithms.
\item \code{\link{est45}}: Example using Eastern Cooperative Oncology Group clinical trial -- a subset of the 'est' data.
\item \code{\link{simulateData}}: Function to simulate response data.
\item \code{\link{simulateCovariateData}}: Function to simulate covariate data.
\item \code{\link{felinedata}}: Sykes et al. (1999) data, the risk factors for Chlamy, a chlamydial infection in cats.
\item \code{\link{simulateMissDfYorX}}: This function generates missing covariate or missing responses data. The missing data generation in the last two supplied covariates will be generated based on a predefined mechanisms. Missing data generation in the response variable will be based on the suppilied true alpha.
\item \code{\link{sixcitydata}}: Longitudinal study of health effects of air pollution using data from six cities Ware et al. (1984).
\item \code{\link{ibrahim}}: Example dataset used in Ibrahim (1990, JASA).
\item \code{\link{testyxm}}: Function for testing models with missing data.
}
}
\references{
Firth, D. (1993). Bias reduction of maximum likelihood estimates, Biometrika, 80, 27-38. doi:10.2307/2336755.

Ibrahim, J. G. (1990). Incomplete data in generalized linear models. Journal of the American Statistical Association 85, 765–769.

Ibrahim, J. G., and Lipsitz, S. R. (1996). Parameter Estimation from Incomplete Data in Binomial Regression when the Missing Data Mechanism is Nonignorable, Biometrics, 52, 1071–1078.

Kosmidis, I., Firth, D. (2021). Jeffreys-prior penalty, finiteness and shrinkage in binomial-response generalized linear models. Biometrika, 108, 71-82. doi:10.1093/biomet/asaa052.

Louis, T. A. (1982). Finding the observed information when using the EM algorithm. Proceedings of the Royal Statistical Society, Ser B, 44, 226-233.

Maiti, T., Pradhan, V. (2009). Bias reduction and a solution of separation of logistic regression with missing covariates. Biometrics, 65, 1262-1269.

Pradhan, V., Nychka, D. and Bandyopadhyay, S. (2025). Beyond the Odds: Fitting Logistic Regression with Missing Data in Small Samples (submitted).

Pradhan, V., Nychka, D., and Bandyopadhyay, S. (2025).  Addressing Missing Responses and Categorical Covariates in Binary Regression Modeling: An Integrated Framework (to be submitted).

Pradhan, V., Nychka, D., and Bandyopadhyay, S. (2025).  Bridging Gaps in Logistic Regression: Tackling Missing Categorical Covariates with a New Likelihood Method (to be submitted).

Pradhan, V., Nychka, D., and Bandyopadhyay, S. (2025).  glmFitMiss: Binary Regression with Missing Data in R (to be submitted).
}
\seealso{
{\link{emBinRegMAR}, \link{emBinRegMixedMAR}, \link{logRegMAR}, \link{meningitis}, \link{emforbeta}, \link{meningitis60ymis}, \link{emyxmiss}, \link{est}, \link{metastmelanoma}, \link{simulateCovariateData}, \link{est45}, \link{simulateData}, \link{felinedata}, \link{sixcitydata}, \link{ibrahim}, \link{testyxm}, \link{llkmiss}}
}
\author{
\strong{Maintainer}: Vivek Pradhan \email{vpradhan2009@gmail.com}

Authors:
\itemize{
  \item Douglas Nychka \email{nychka@mines.edu}
  \item Soutir Bandyopadhyay \email{bsoutir@gmail.com}
}

}
\keyword{package}
