% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emBinRegNonIG.R
\name{emBinRegNonIG}
\alias{emBinRegNonIG}
\title{Fitting binary regression with missing responses that are nonignorable based on Ibrahim and Lipsitz (1996)}
\usage{
emBinRegNonIG(
  formula,
  data,
  conflev = 0.95,
  vcorctn = TRUE,
  biascorrectn = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{formula}{a formula expression as for regression models, of the form response ~ predictors. The response should be a numeric binary variable with missing values, and predictors can be any variables. A predictor with categorical values with missing can be used in the model. See the documentation of formula for other details.}

\item{data}{Input data for fitting the model}

\item{conflev}{a value for the confidence interval, the default is 0.95}

\item{vcorctn}{a variance-covariance matrix computation using Louis (1982). Default is TRUE.}

\item{biascorrectn}{a TRUE or FALSE value, an option for bias reduced estimates due to Firth (1993). The default is TRUE}

\item{verbose}{a TRUE or FALSE value, default is verbose = TRUE}
}
\value{
return the glm estimates
}
\description{
This function allows users to fit binary regression models with nonignorable missing responses. The model is fitted using a likelihood-based method, which ensures reliable parameter estimation even when dealing with missing data. For more information on the underlying methodology, please refer to Pradhan, Nychka, and Bandyopadhyay (2025).
}
\details{
The \code{family} parameter in the \code{emBinRegNonIG} function allows you to specify the binomial distribution and link function for the response variable in the linear model. It determines the nature of the relationship between the predictors and the response variable.
The \code{family} argument is particularly important when working with binary data, where the response variable has only two possible outcomes. In such cases, you typically want to fit a binary regression model.

You can also specify different link functions within binomial family. The default link function is the logit function, which models the log-odds of success. Other available link functions include:
\itemize{
\item "probit" for the probit link function, which models the cumulative standard normal distribution.
\item "cloglog" for the complementary log-log link function, which models the complementary log-log of the survival function.
}

It is important to choose the appropriate \code{link} function based on the specific characteristics and assumptions of your binary data. The default "binomial" family with the logit link function is often a good starting point, but alternative link functions might be more appropriate depending on the research question and the nature of the data.
Note that, this function uses the function 'emforbeta' function. For more details of the function and corresponding different output objects, review the 'emforbeta' function.
}
\examples{
data(incontinence)
#Fits a binary regression mode with nonignorable missing responses using Ibrahim and Lipsitz (1996)
#biascorrectn=TRUE enables Firth type bias correction of the parameter estimates
fit <- emBinRegNonIG(y~x1+x2+x3, data=incontinence, biascorrectn=TRUE)
fit$beta
#prints the nonignorable missing mechanism
summary(fit$alpha)
}
\references{
Firth, D. (1993). Bias reduction of maximum likelihood estimates, Biometrika, 80, 27-38. doi:10.2307/2336755.

Ibrahim, J. G. (1990). Incomplete data in generalized linear models. Journal of the American Statistical Association 85, 765–769.

Ibrahim, J. G., and Lipsitz, S. R. (1996). Parameter Estimation from Incomplete Data in Binomial Regression when the Missing Data Mechanism is Nonignorable, Biometrics, 52, 1071–1078.

Kosmidis, I., Firth, D. (2021). Jeffreys-prior penalty, finiteness and shrinkage in binomial-response generalized linear models. Biometrika, 108, 71-82. doi:10.1093/biomet/asaa052.

Louis, T. A. (1982). Finding the observed information when using the EM algorithm. Proceedings of the Royal Statistical Society, Ser B, 44, 226-233.

Maiti, T., Pradhan, V. (2009). Bias reduction and a solution of separation of logistic regression with missing covariates. Biometrics, 65, 1262-1269.

Pradhan, V., Nychka, D. and Bandyopadhyay, S. (2025). Beyond the Odds: Fitting Logistic Regression with Missing Data in Small Samples (submitted).
}
