% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models_gipsQDA.R
\name{gipsqda}
\alias{gipsqda}
\alias{gipsqda.default}
\alias{gipsqda.formula}
\alias{gipsqda.data.frame}
\alias{gipsqda.matrix}
\alias{predict.gipsqda}
\alias{print.gipsqda}
\alias{model.frame.gipsqda}
\title{Quadratic Discriminant Analysis with gips covariance projection}
\usage{
gipsqda(x, ...)

\method{gipsqda}{formula}(formula, data, ..., subset, na.action)

\method{gipsqda}{default}(x, grouping, prior = proportions,
  nu = 5, MAP = TRUE, optimizer = NULL, max_iter = NULL, ...)

\method{gipsqda}{data.frame}(x, ...)

\method{gipsqda}{matrix}(x, grouping, ..., subset, na.action)
}
\arguments{
\item{x}{(required if no formula is given as the principal argument)
a matrix or data frame containing the explanatory variables.}

\item{...}{Arguments passed to or from other methods.}

\item{formula}{A formula of the form \code{groups ~ x1 + x2 + ...}.
The response is the grouping factor and the right-hand side specifies
the (non-factor) discriminators.}

\item{data}{An optional data frame, list or environment from which variables
specified in \code{formula} are preferentially taken.}

\item{grouping}{(required if no formula is given)
a factor specifying the class for each observation.}

\item{prior}{The prior probabilities of class membership.
Must sum to one and have length equal to the number of groups.}

\item{nu}{Degrees of freedom parameter used internally by covariance
projection.}

\item{MAP}{Logical; if \code{TRUE}, maximum a posteriori covariance projection
is used.}

\item{optimizer}{Character string specifying the optimization method used
for covariance projection. If \code{NULL}, a default choice depending on
the problem dimension is used.}

\item{max_iter}{Maximum number of iterations for stochastic optimizers.}

\item{subset}{An index vector specifying the cases to be used in the training
sample. (NOTE: must be named.)}

\item{na.action}{A function specifying the action to be taken if \code{NA}s
are found.}
}
\value{
An object of class \code{"gipsqda"} containing the following components:
\itemize{
\item \code{prior}: prior probabilities of the groups
\item \code{counts}: number of observations in each group
\item \code{means}: group means
\item \code{scaling}: group-specific scaling matrices derived from the
projected covariance matrices
\item \code{ldet}: log-determinants of the projected covariance matrices
\item \code{lev}: class labels
\item \code{N}: total number of observations
\item \code{optimization_info}: information returned by the covariance
projection optimizer
\item \code{call}: the matched call
}
}
\description{
Quadratic discriminant analysis (QDA) using covariance matrices projected
via the \emph{gips} framework to enforce permutation symmetry and improve
numerical stability.
}
\details{
This function is a minor modification of \code{\link[MASS]{qda}}, replacing
the classical sample covariance estimators by projected covariance matrices
obtained using \code{project_covs()}.

Quadratic discriminant analysis models each class with its own covariance
matrix. In \code{gipsqda}, these covariance matrices are projected using the
\emph{gips} framework, which enforces permutation symmetry and mitigates
singularity and overfitting in high-dimensional or small-sample settings.

Classification can be performed using plug-in, predictive, debiased,
or leave-one-out cross-validation rules via \code{\link{predict.gipsqda}}.
}
\note{
The function may be called with either a formula interface or with a matrix
and grouping factor. Arguments \code{subset} and \code{na.action}, if used,
must be named.
}
\examples{
tr <- sample(1:50, 25)
train <- rbind(iris3[tr, , 1], iris3[tr, , 2], iris3[tr, , 3])
test <- rbind(iris3[-tr, , 1], iris3[-tr, , 2], iris3[-tr, , 3])
cl <- factor(c(rep("s", 25), rep("c", 25), rep("v", 25)))
z <- gipsqda(train, cl)
predict(z, test)$class

}
\references{
Chojecki, A., et al. (2025).
\emph{Learning Permutation Symmetry of a Gaussian Vector with gips in R}.
Journal of Statistical Software, \strong{112}(7), 1--38.
\doi{10.18637/jss.v112.i07}

Venables, W. N. and Ripley, B. D. (2002).
\emph{Modern Applied Statistics with S}. Fourth edition. Springer.
}
\seealso{
\code{\link[MASS]{qda}}, \code{\link{predict.gipsqda}},
\code{\link{gipslda}}, \code{\link[MASS]{lda}}
}
\keyword{classification}
\keyword{multivariate}
